<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Pembayaran Baru - Admin</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #DC2626; color: white; padding: 20px; text-align: center; }
        .content { background: #f9f9f9; padding: 20px; }
        .footer { background: #333; color: white; padding: 15px; text-align: center; font-size: 12px; }
        .alert { background: #FEF3C7; color: #92400E; padding: 15px; border-radius: 5px; margin: 15px 0; border-left: 4px solid #F59E0B; }
        .info-box { background: white; padding: 15px; border-radius: 5px; margin: 15px 0; border-left: 4px solid #DC2626; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔔 Pembayaran Baru!</h1>
            <p>Notifikasi Admin - Klinik Kecantikan</p>
        </div>
        
        <div class="content">
            <div class="alert">
                <h2>⚠️ Ada pembayaran baru yang perlu diproses!</h2>
            </div>
            
            <p>Halo Admin,</p>
            
            <p>Sebuah pembayaran baru telah berhasil diproses dan memerlukan tindak lanjut dari tim klinik.</p>
            
            <div class="info-box">
                <h3>Detail Pembayaran:</h3>
                <ul>
                    <li><strong>No. Registrasi:</strong> {{ $registration->registration_number }}</li>
                    <li><strong>Nama Pasien:</strong> {{ $patient->name }}</li>
                    <li><strong>Email:</strong> {{ $patient->email }}</li>
                    <li><strong>Telepon:</strong> {{ $patient->phone }}</li>
                    <li><strong>Tanggal Pemeriksaan:</strong> {{ $registration->exam_date->format('d/m/Y') }}</li>
                    <li><strong>Jenis Pemeriksaan:</strong> {{ ucfirst($registration->exam_type) }}</li>
                    <li><strong>Jumlah Pembayaran:</strong> Rp {{ number_format($payment->amount, 0, ',', '.') }}</li>
                    <li><strong>Tanggal Bayar:</strong> {{ $payment->paid_at->format('d/m/Y H:i') }}</li>
                    <li><strong>External ID:</strong> {{ $payment->external_id }}</li>
                </ul>
            </div>
            
            <h3>Tindakan yang Diperlukan:</h3>
            <ol>
                <li>Verifikasi data pasien dan pembayaran</li>
                <li>Konfirmasi jadwal pemeriksaan</li>
                <li>Persiapkan ruang pemeriksaan sesuai jenis pemeriksaan</li>
                <li>Kirim reminder kepada pasien 1 hari sebelum pemeriksaan</li>
            </ol>
            
            <p><strong>Catatan:</strong> Pastikan semua persiapan pemeriksaan telah selesai sebelum tanggal yang ditentukan.</p>
            
            <p>Silakan akses sistem admin untuk detail lebih lanjut.</p>
        </div>
        
        <div class="footer">
            <p>&copy; {{ date('Y') }} Klinik Kecantikan. Semua hak dilindungi.</p>
        </div>
    </div>
</body>
</html>
